/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.IntValueProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;

public class AstronomicalClockParameter
extends ProtectionParameter
implements ParameterSetListener {
    private static final long serialVersionUID = 1021636591665449539L;
    private Theodolite fLongitude;
    private Theodolite fLatitude;
    private IntValueProperties fTimeZone;
    private String fCity;
    private transient Hours fDSTSunriseTime;
    private transient Hours fDSTSunsetTime;
    private transient Hours fSunsetTime;
    private transient Hours fSunriseTime;
    private transient int fDSTOffset;

    public AstronomicalClockParameter() {
    }

    public AstronomicalClockParameter(Block block) {
        super(block);
    }

    protected String calculateCurrentParameterText() {
        return "TR: " + this.getDSTSunriseTime() + "\n" + "TS: " + this.getDSTSunsetTime();
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Lot: ").append(this.getLongitude()).append(this.getProtectionSign()).append("\n").append("Lat: ").append(this.getLatitude()).append("\n").append("TZ: ").append(this.getTimeZone()).append("\n");
        return buffer.toString();
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        this.fireParameterSetEvent();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getLongitude());
        dw.writeStorable(this.getLatitude());
        dw.writeInt(this.fTimeZone.getCurrentValue());
        dw.writeString(this.fCity);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setLongitude((Theodolite)dr.readStorable());
        this.setLatitude((Theodolite)dr.readStorable());
        this.setTimeZone(dr.readInt());
        this.setCity(dr.readString());
    }

    public Theodolite getLatitude() {
        if (this.fLatitude == null) {
            this.fLatitude = new Theodolite(1, 0, 0, 0, 0);
        }
        return this.fLatitude;
    }

    public void setLatitude(Theodolite latitude) {
        this.fLatitude = latitude;
    }

    public Theodolite getLongitude() {
        if (this.fLongitude == null) {
            this.fLongitude = new Theodolite(0, 0, 0, 0, 0);
        }
        return this.fLongitude;
    }

    public void setLongitude(Theodolite longitude) {
        this.fLongitude = longitude;
    }

    public IntValueProperties getTimeZone() {
        if (this.fTimeZone == null) {
            this.fTimeZone = new IntValueProperties(-11, 12, 1, 0, "", "");
        }
        return this.fTimeZone;
    }

    public void setTimeZone(IntValueProperties timeZone) {
        this.getTimeZone().setCurrentValue(timeZone.getCurrentValue());
    }

    public void setTimeZone(int timeZone) {
        this.getTimeZone().setCurrentValue(timeZone);
    }

    public String getCity() {
        return this.fCity;
    }

    public void setCity(String city) {
        this.fCity = city;
    }

    public Hours getDSTSunriseTime() {
        if (this.fDSTSunriseTime == null) {
            this.fDSTSunriseTime = new Hours();
        }
        int dstOffset = Calendar.getInstance().get(16);
        this.fDSTSunriseTime.setMilliseconds(this.getSunriseTime().getMilliseconds() + (long)dstOffset);
        if (dstOffset != this.fDSTOffset) {
            this.fDSTOffset = dstOffset;
            this.fCurrentParameterText = this.calculateCurrentParameterText();
        }
        return this.fDSTSunriseTime;
    }

    public Hours getDSTSunsetTime() {
        if (this.fDSTSunsetTime == null) {
            this.fDSTSunsetTime = new Hours();
        }
        this.fDSTSunsetTime.setMilliseconds(this.getSunsetTime().getMilliseconds() + (long)Calendar.getInstance().get(16));
        return this.fDSTSunsetTime;
    }

    private Hours getSunriseTime() {
        if (this.fSunriseTime == null) {
            this.fSunriseTime = new Hours();
        }
        return this.fSunriseTime;
    }

    private Hours getSunsetTime() {
        if (this.fSunsetTime == null) {
            this.fSunsetTime = new Hours();
        }
        return this.fSunsetTime;
    }

    public int getDegree(String latOrLon) {
        return Integer.valueOf(latOrLon.substring(1, latOrLon.indexOf("\u00b0")));
    }

    public int getMinute(String latOrLon) {
        return Integer.valueOf(latOrLon.substring(latOrLon.indexOf("\u00b0") + 1, latOrLon.indexOf("'")));
    }

    public int getSecond(String latOrLon) {
        return Integer.valueOf(latOrLon.substring(latOrLon.indexOf("'") + 1, latOrLon.length() - 1));
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getSunriseTime().setTime(0);
        this.getSunsetTime().setTime(0);
    }

    public boolean getValue() {
        if (this.getLatitude().toString().length() == 0 || this.getLongitude().toString().length() == 0) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.fInterpreter.getCurrentSimulationClockTime());
        int minutes = calendar.get(12);
        int hoursOfDay = calendar.get(11);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        int currentTime = hoursOfDay * 60 + minutes;
        this.calRiseSetTime(this.mjd(day, month, year), this.getTimeZone().getCurrentValue(), this.fLongitude.toNumeric(), this.fLatitude.toNumeric());
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        if (this.getSunriseTime().getTimeValue() > this.getSunsetTime().getTimeValue()) {
            return this.getDSTSunriseTime().getTimeValue() < currentTime || currentTime < this.getDSTSunsetTime().getTimeValue();
        }
        return this.getDSTSunriseTime().getTimeValue() <= currentTime && currentTime <= this.getDSTSunsetTime().getTimeValue();
    }

    private void hrsmin(double hours, int rs) {
        double hrs = Math.floor(hours * 60.0 + 0.5) / 60.0;
        short h = (short)Math.floor(hrs);
        short m = (short)Math.floor(60.0 * (hrs - (double)h) + 0.5);
        if (1 == rs) {
            this.getSunriseTime().setTime(h * 60 + m);
        } else {
            this.getSunsetTime().setTime(h * 60 + m);
        }
    }

    private double ipart(double x) {
        double a = x > 0.0 ? Math.floor(x) : Math.ceil(x);
        return a;
    }

    private double frac(double x) {
        double a = x - Math.floor(x);
        if (a < 0.0) {
            a += 1.0;
        }
        return a;
    }

    private double range(double x) {
        double b = x / 360.0;
        double a = 360.0 * (b - this.ipart(b));
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }

    private double mjd(double day, double month, double year) {
        double a;
        if (month <= 2.0) {
            month += 12.0;
            year -= 1.0;
        }
        double b = (a = 10000.0 * year + 100.0 * month + day) <= 1.58210041E7 ? -2.0 * Math.floor((year + 4716.0) / 4.0) - 1179.0 : Math.floor(year / 400.0) - Math.floor(year / 100.0) + Math.floor(year / 4.0);
        a = 365.0 * year - 679004.0;
        return a + b + Math.floor(30.6001 * (month + 1.0)) + day;
    }

    private int quad(double ym, double yz, double yp, double[] quadout) {
        int nz = 0;
        double z1 = 0.0;
        double z2 = 0.0;
        double a = 0.5 * (ym + yp) - yz;
        double b = 0.5 * (yp - ym);
        double c = yz;
        double xe = -b / (2.0 * a);
        double ye = (a * xe + b) * xe + c;
        double dis = b * b - 4.0 * a * c;
        if (dis > 0.0) {
            double dx = 0.5 * Math.sqrt(dis) / Math.abs(a);
            z1 = xe - dx;
            z2 = xe + dx;
            if (Math.abs(z1) <= 1.0) {
                ++nz;
            }
            if (Math.abs(z2) <= 1.0) {
                ++nz;
            }
            if (z1 < -1.0) {
                z1 = z2;
            }
        }
        quadout[0] = nz;
        quadout[1] = z1;
        quadout[2] = z2;
        quadout[3] = xe;
        quadout[4] = ye;
        return nz;
    }

    private double lmst(double mjd, double glong) {
        double d = mjd - 51544.5;
        double t = d / 36525.0;
        double lst = this.range(280.46061837 + 360.98564736629 * d + 3.87933E-4 * t * t - t * t * t / 3.871E7);
        return lst / 15.0 + glong / 15.0;
    }

    private void minisun(double t, double[] suneq) {
        double p2 = 6.283185307;
        double coseps = 0.91748;
        double sineps = 0.39778;
        double M = p2 * this.frac(0.993133 + 99.997361 * t);
        double DL = 6893.0 * Math.sin(M) + 72.0 * Math.sin(2.0 * M);
        double L = p2 * this.frac(0.7859453 + M / p2 + (6191.2 * t + DL) / 1296000.0);
        double SL = Math.sin(L);
        double X = Math.cos(L);
        double Y = coseps * SL;
        double Z = sineps * SL;
        double RHO = Math.sqrt(1.0 - Z * Z);
        double dec = 360.0 / p2 * Math.atan(Z / RHO);
        double ra = 48.0 / p2 * Math.atan(Y / (X + RHO));
        if (ra < 0.0) {
            ra += 24.0;
        }
        suneq[1] = dec;
        suneq[2] = ra;
    }

    private double sin_alt(double iobj, double mjd0, double hour, double glong, double cglat, double sglat) {
        double rads = 0.0174532925;
        double[] objpos = new double[4];
        double mjd = mjd0 + hour / 24.0;
        double t = (mjd - 51544.5) / 36525.0;
        this.minisun(t, objpos);
        double ra = objpos[2];
        double dec = objpos[1];
        double tau = 15.0 * (this.lmst(mjd, glong) - ra);
        double salt = sglat * Math.sin(rads * dec) + cglat * Math.cos(rads * dec) * Math.cos(rads * tau);
        return salt;
    }

    private void calRiseSetTime(double mjd, double tz, double glong, double glat) {
        double utrise = 0.0;
        double utset = 0.0;
        double rads = 0.0174532925;
        double[] quadout = new double[5];
        double sinho = Math.sin(rads * -0.833);
        double sglat = Math.sin(rads * glat);
        double cglat = Math.cos(rads * glat);
        double date = mjd - tz / 24.0;
        boolean rise = false;
        boolean sett = false;
        boolean above = false;
        double hour = 1.0;
        double ym = this.sin_alt(2.0, date, hour - 1.0, glong, cglat, sglat) - sinho;
        if (ym > 0.0) {
            above = true;
        }
        while (!(!(hour < 25.0) || sett && rise)) {
            double yz = this.sin_alt(2.0, date, hour, glong, cglat, sglat) - sinho;
            double yp = this.sin_alt(2.0, date, hour + 1.0, glong, cglat, sglat) - sinho;
            int nz = this.quad(ym, yz, yp, quadout);
            double z1 = quadout[1];
            double z2 = quadout[2];
            double ye = quadout[4];
            if (nz == 1) {
                if (ym < 0.0) {
                    utrise = hour + z1;
                    rise = true;
                } else {
                    utset = hour + z1;
                    sett = true;
                }
            }
            if (nz == 2) {
                if (ye < 0.0) {
                    utrise = hour + z2;
                    utset = hour + z1;
                } else {
                    utrise = hour + z1;
                    utset = hour + z2;
                }
            }
            ym = yp;
            hour += 2.0;
        }
        if (rise || sett) {
            if (rise) {
                this.hrsmin(utrise, 1);
            }
            if (sett) {
                this.hrsmin(utset, 0);
            }
        } else if (above) {
            this.getSunriseTime().setTime(0);
            this.getSunsetTime().setTime(1440);
        } else {
            this.getSunriseTime().setTime(1440);
            this.getSunsetTime().setTime(0);
        }
    }

    public static class Theodolite
    implements Serializable,
    Storable {
        private static final long serialVersionUID = -802177237346281625L;
        private int type;
        private int dir;
        private int degree;
        private int minute;
        private int second;
        public static final transient int LONGITUDE = 0;
        public static final transient int LATITUDE = 1;

        public Theodolite() {
            this.type = -1;
        }

        public Theodolite(int type, int dir, int degree, int minute, int second) {
            this.type = type;
            this.dir = dir;
            this.degree = degree;
            this.second = second;
            this.minute = minute;
        }

        public int getDegree() {
            return this.degree;
        }

        public void setDegree(int degree) {
            this.degree = degree;
        }

        public int getMinute() {
            return this.minute;
        }

        public void setMinute(int minute) {
            this.minute = minute;
        }

        public int getSecond() {
            return this.second;
        }

        public void setSecond(int second) {
            this.second = second;
        }

        public int getDir() {
            return this.dir;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setDir(int dir) {
            this.dir = dir;
        }

        public void read(StorableInput dr) throws IOException {
            this.type = dr.readInt();
            this.dir = dr.readInt();
            this.degree = dr.readInt();
            this.minute = dr.readInt();
            this.second = dr.readInt();
        }

        public void write(StorableOutput dw) {
            dw.writeInt(this.type);
            dw.writeInt(this.dir);
            dw.writeInt(this.degree);
            dw.writeInt(this.minute);
            dw.writeInt(this.second);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Theodolite)) {
                return false;
            }
            Theodolite objNew = (Theodolite)obj;
            return this.type == objNew.getType() && this.dir == objNew.getDir() && this.degree == objNew.getDegree() && this.minute == objNew.getMinute() && this.second == objNew.getSecond();
        }

        public String toString() {
            if (this.type == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            if (this.type == 0) {
                sb.append(this.getDir() == 0 ? "E" : "W");
            } else {
                sb.append(this.getDir() == 0 ? "N" : "S");
            }
            return sb.append(this.getDegree()).append("\u00b0").append(this.getMinute()).append("'").append(this.getSecond()).append("\"").toString();
        }

        public double toNumeric() {
            double ret = (double)this.degree + (double)this.minute / 60.0 + (double)this.second / 3600.0;
            if (this.dir == 1) {
                ret = -ret;
            }
            return ret;
        }
    }
}

